SceneObject sObj1;
SceneObject sObj2;

void setup() {
  size(400,400);
  sObj1 = new SceneObject(50,50,50,50,0,255,0);
  sObj2 = new SceneObject(100,100,50,50,0,255,0);
}

void draw() {
  background(255);
  handleInput();
  detectCollisions();
  sObj1.drawObject();
  sObj2.drawObject();
}
void handleInput() {
  if (keyPressed == true) {
    if (key == 'a') {
      sObj1.moveHorizontally(-1);
    } else if (key == 'd') {
      sObj1.moveHorizontally(1);
    } else if (key == 'w') {
      sObj1.moveVertically(-1);
    } else if (key == 's') {
      sObj1.moveVertically(1);
    }
  }
}
void detectCollisions() {
  // Test if boxes are touching
  if (sObj1.isIntersecting(sObj2.bb)) {
    sObj1.setColor(255,0,0);
  } else {
    sObj1.setColor(0,255,0);
  }
  
  // Test if mouse is over first box
  if (sObj1.isIntersecting(mouseX,mouseY)) {
    sObj1.setColor(255,0,0);
  } else {
    if (!sObj1.isIntersecting(sObj2.bb)) {
      sObj1.setColor(0,255,0);
    }
  }
  // Test if mouse is over second box
  if (sObj2.isIntersecting(mouseX,mouseY)) {
    sObj2.setColor(255,0,0);
  } else {
    if (!sObj1.isIntersecting(sObj2.bb)) {
      sObj2.setColor(0,255,0);
    }
  }
}

class SceneObject
{
  int centerX, centerY;
  int wdth, hght;
  BoundingBox bb;
  int r,g,b;
  SceneObject(int cx, int cy, int w, int h, int rd, int gr, int bl) {
    centerX = cx;
    centerY = cy;
    wdth = w;
    hght = h;
    setColor(rd,gr,bl);
    updateBoundingBox();
  }
  void drawObject() {
    pushMatrix();
    translate(centerX,centerY);
    fill(r,g,b);
    rect(-(wdth/2),-(hght/2),wdth,hght);
    popMatrix();
  }
  void updateBoundingBox() {
    bb = new BoundingBox(centerX-(wdth/2),centerY-(hght/2),centerX+(wdth/2),centerY-(hght/2),
                         centerX+(wdth/2),centerY+(hght/2),centerX-(wdth/2),centerY+(hght/2));
  }
  void setColor(int rd, int gr, int bl) {
    r = rd;
    g = gr;
    b = bl;
  }
  void move(int x, int y) {
    centerX = x;
    centerY = y;
    updateBoundingBox();
  }
  void moveHorizontally(int x) {
    centerX += x;
    updateBoundingBox();
  }
  void moveVertically(int y) {
    centerY += y;
    updateBoundingBox();
  }
  boolean isIntersecting(BoundingBox otherBox) {
    return bb.isIntersecting(otherBox);
  }
  boolean isIntersecting(int x, int y) {
    return bb.isIntersecting(x,y);
  }
}

class BoundingBox
{
  int upperLeftX, upperLeftY;
  int upperRightX, upperRightY;
  int lowerLeftX, lowerLeftY;
  int lowerRightX, lowerRightY;
  
  BoundingBox(int ulX, int ulY,
              int urX, int urY,
              int lrX, int lrY,
              int llX, int llY) {
    upperLeftX = ulX;
    upperLeftY = ulY;
    upperRightX = urX;
    upperRightY = urY;
    lowerRightX = lrX;
    lowerRightY = lrY;
    lowerLeftX = llX;
    lowerLeftY = llY;
  }
  boolean isIntersecting(BoundingBox bb) {
    // Test incoming bb's upper left corner
    if (isIntersecting(bb.upperLeftX,bb.upperLeftY)) {
      return true;
    }
    // Test incoming bb's upper right corner
    else if (isIntersecting(bb.upperRightX,bb.upperRightY)) {
      return true;
    }
    // Test incoming bb's lower right corner
    else if (isIntersecting(bb.lowerRightX,bb.lowerRightY)) {
      return true;
    }
    // Test incoming bb's lower left corner
    else if (isIntersecting(bb.lowerLeftX,bb.lowerLeftY)) {
      return true;
    }
    else {
      return false;
    }
  }
  boolean isIntersecting(int x, int y) {
    if (( x > upperLeftX) && (x < upperRightX) && (y > upperLeftY) && (y < lowerLeftY)) {
      return true;
    } else {
      return false;
    }
  }
  String toString() {
    String out = new String();
    out += "(" + upperLeftX + "," + upperLeftY + ")";
    out += "(" + upperRightX + "," + upperRightY + ")";
    out += "(" + lowerRightX + "," + lowerRightY + ")";
    out += "(" + lowerLeftX + "," + lowerLeftY + ")";
    return out;
  }
}

