﻿package{
	
	//import packages needed for the game
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.ui.*;
	
	//3rd party packages
	import Key;
	
	//this class represents the flash root, so it must extend the movieclip type
	public class gameMain extends MovieClip {
		
		/*
			constants used in the game go here
		*/
		const gravity:Number = 1;
		const friction:Number = .8;
		const speed:Number = 5;
		const jump:Number = 10;
		
		/*
			game variables
		*/
		public var playerVelocity:Object;
		public var onGround:Boolean;
		
		/*
			objects user in the game
		*/
		public var player:MovieClip;
		public var gameStage:MovieClip;
		
		//runs first
		public function gameMain():void {
			
			//initialize any game objects
			
			//new player
			player = new tinyMan();
			player.x = 100;
			
			//new stage
			gameStage = new stage1();
			
			//new player velocity
			playerVelocity = new Object();
			playerVelocity.x = 0;
			playerVelocity.y = 0;
			
			//misc
			onGround = false;
			Key.initialize( stage );
			
			//add objects to the stage as needed
			this.addChild( gameStage );
			this.addChild( player );
			
			//start game loop
			this.addEventListener( 'enterFrame', onEnterFrame );
		}
		
		//the code within this function will run once every frame
		public function onEnterFrame( e:Event ):void {
			
			updateInput();
			
			//update velocity
			playerVelocity.y += gravity;
			playerVelocity.x *= friction;
			
			//test to see if the player is on the ground
			if( gameStage.hitTestPoint(player.x, player.y, true) && playerVelocity.y > 0) {
				//if it has hit the ground, halt gravity
				playerVelocity.y = 0;
				//set on ground to true
				onGround = true;
			} else {
				//hes not on the ground, let the game know this.
				onGround = false;
			}
			
			//update position
			player.x += playerVelocity.x;
			player.y += playerVelocity.y;
			
		}
		
		//handle input
		public function updateInput():void {
			
			if( Key.isDown( Keyboard.LEFT ) ) {
				playerVelocity.x = -speed;
			}
			
			if( Key.isDown( Keyboard.RIGHT ) ) {
				playerVelocity.x = speed;
			}
			
			if( Key.isDown( Keyboard.UP ) ) {
				if( onGround ) {
					onGround = false;
					playerVelocity.y = -jump;
				}
			}
			
		}
		
	}
	
}