﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

/////////////////////////////////////
using System.IO;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;
using System.Xml.XPath;
using System.Xml.Xsl;
/////////////////////////////////////

/////////////////////////////////////
// need to give ASPNET and IIS_WPG
// accounts Modify permission on the
// folder for this to be able to 
// save the file.
/////////////////////////////////////

public partial class WriteSimpleXml : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

        // Create a new file in C:\\ dir
        XmlTextWriter textWriter = new XmlTextWriter(MapPath("~/XML/myNewFile.xml"), null);

        //without this, if the page crashes, you won't be able to access the file 
        //anymore because the XmlTextWriter opened it and it was never closed.
        try
        {
            // Opens the document 
            textWriter.WriteStartDocument();

            textWriter.WriteWhitespace("\r\n"); //new line

            // Write comments
            textWriter.WriteComment("First Comment XmlTextWriter Example");
            textWriter.WriteWhitespace("\r\n"); //new line
            textWriter.WriteComment("myNewFile.xml in root dir");

            textWriter.WriteWhitespace("\r\n\r\n"); //new line

            // Write first element
            textWriter.WriteStartElement("Student");
            textWriter.WriteWhitespace("\r\n\t"); //new line
            textWriter.WriteStartElement("r", "RECORD", "urn:record");

            textWriter.WriteWhitespace("\r\n\t\t"); //new line

            // Write next element
            textWriter.WriteStartElement("Name", "");
            textWriter.WriteString("Joseph Pumpernickle");
            textWriter.WriteEndElement();

            textWriter.WriteWhitespace("\r\n\t\t"); //new line

            // Write one more element
            textWriter.WriteStartElement("Address", ""); 
            textWriter.WriteString("123 N. South St.");
            textWriter.WriteEndElement();

            textWriter.WriteWhitespace("\r\n\t\t"); //new line

            // WriteChars
            char[] ch = new char[3];
            ch[0] = 'a';
            ch[1] = 'b';
            ch[2] = 'c';
            textWriter.WriteStartElement("Char");
            textWriter.WriteChars(ch, 0, ch.Length);
            textWriter.WriteEndElement();

            textWriter.WriteWhitespace("\r\n\t"); //new line

            // Ends the record element.
            //instead of doing this, you could just do a WriteEndDocument and it would automatically
            //close all elements that are still left open.
            textWriter.WriteEndElement();

            // Ends the document.
            textWriter.WriteWhitespace("\r\n"); //new line
            textWriter.WriteEndDocument();

            // close writer
            textWriter.Close();

            //notify user
            Response.Write("XML file created...");
        }
        catch
        {
            textWriter.Close();

            //notify user
            Response.Write("There were errors...");
        }

    }
}
