﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

/////////////////////////////////////
using System.IO;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;
using System.Xml.XPath;
using System.Xml.Xsl;
/////////////////////////////////////

/////////////////////////////////////
// need to give ASPNET and IIS_WPG
// accounts Modify permission on the
// folder for this to be able to 
// save the file.
/////////////////////////////////////

public partial class CreateRssFeed : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //Create the XML file
        XmlTextWriter myXMLFileWriter = new XmlTextWriter(MapPath("~/XML/newRssFeed.xml"), null);

        //without this, if the page crashes, you won't be able to access the file 
        //anymore because the XmlTextWriter opened it and it was never closed.
        try
        {
            myXMLFileWriter.WriteStartDocument();
            myXMLFileWriter.WriteWhitespace("\r\n"); //new line
            myXMLFileWriter.WriteComment("Ronald J. Glotzbach");
            myXMLFileWriter.WriteWhitespace("\r\n"); //new line

            //RSS Element
            myXMLFileWriter.WriteStartElement("rss");
            myXMLFileWriter.WriteAttributeString("version", "2.0");
            myXMLFileWriter.WriteWhitespace("\r\n\t"); //new line
            //Channel Element - START
            myXMLFileWriter.WriteStartElement("channel");
            myXMLFileWriter.WriteWhitespace("\r\n\t\t"); //new line
            //RSS FEED DETAILS - Title
            myXMLFileWriter.WriteStartElement("title");
            myXMLFileWriter.WriteString("OneSource");
            myXMLFileWriter.WriteEndElement();
            myXMLFileWriter.WriteWhitespace("\r\n\t\t"); //new line
            //RSS FEED DETAILS - Link
            myXMLFileWriter.WriteStartElement("link");
            myXMLFileWriter.WriteString("http://cgtmm1.tech.purdue.edu/456/rjglotzbach/WorkingSolutions/WriteXML/XML/newRssFeed.xml");
            myXMLFileWriter.WriteEndElement();
            myXMLFileWriter.WriteWhitespace("\r\n\t\t"); //new line
            //RSS FEED DETAILS - Description
            myXMLFileWriter.WriteStartElement("description");
            myXMLFileWriter.WriteString("Lastest Activity on OneSource - The CGT Wiki");
            myXMLFileWriter.WriteEndElement();
            myXMLFileWriter.WriteWhitespace("\r\n\t\t"); //new line
            //RSS FEED DETAILS - Language
            myXMLFileWriter.WriteStartElement("language");
            myXMLFileWriter.WriteString("en-us");
            myXMLFileWriter.WriteEndElement();
            myXMLFileWriter.WriteWhitespace("\r\n\t\t"); //new line
            //RSS FEED DETAILS - Copyright
            myXMLFileWriter.WriteStartElement("copyright");
            myXMLFileWriter.WriteString("Copyright 2008 Purdue University");
            myXMLFileWriter.WriteEndElement();
            myXMLFileWriter.WriteWhitespace("\r\n\t\t"); //new line
            //RSS FEED DETAILS - Docs
            myXMLFileWriter.WriteStartElement("docs");
            myXMLFileWriter.WriteString("http://cgtmm1.tech.purdue.edu/456/rjglotzbach/WorkingSolutions/WriteXML/");
            myXMLFileWriter.WriteEndElement();
            myXMLFileWriter.WriteWhitespace("\r\n\t\t"); //new line
            //RSS FEED DETAILS - LastBuildDate
            myXMLFileWriter.WriteStartElement("lastBuildDate");
            DateTime datetime = DateTime.Now.Date;
            myXMLFileWriter.WriteString(Convert.ToString(datetime));
            myXMLFileWriter.WriteEndElement();
            myXMLFileWriter.WriteWhitespace("\r\n\t"); //new line
            //end <channel>
            myXMLFileWriter.WriteEndElement();
            myXMLFileWriter.WriteWhitespace("\r\n"); //new line
            //end <rss>
            myXMLFileWriter.WriteEndDocument();

            // <item> Elements Go Here

            myXMLFileWriter.Close();

            //notify user:
            Response.Write("initial file created...<br/>");

            //Open XML File
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(MapPath("~/XML/newRssFeed.xml"));

            //Find the Element "lastBuildDate"
            XmlNode selectedNode = xmlDoc.DocumentElement.FirstChild.ChildNodes.Item(6);

            XmlElement subRoot = xmlDoc.CreateElement("item");                    //Create an <item>
            XmlElement appendedElementTitle = xmlDoc.CreateElement("title");      //add <title> to <item>
            XmlText xmlTextTitle = xmlDoc.CreateTextNode("ADDED: New feed item"); //add text inside of <title>
            appendedElementTitle.AppendChild(xmlTextTitle);                       //append text to <title>
            subRoot.AppendChild(appendedElementTitle);                            //append <title> to <item>
            xmlDoc.DocumentElement.FirstChild.InsertAfter(subRoot, selectedNode); //insert <item> into document

            xmlDoc.Save(MapPath("~/XML/newRssFeed.xml"));

            //notify user:
            Response.Write("AppendChild completed...<br/>");



        }
        catch
        {
            myXMLFileWriter.Close();

            //notify user
            Response.Write("There were errors...");
        }

    }
}
